*-------------------------------------------------------------------------------
*
*
*				Trumponomics - Relation between tax probabilities and industry valuation in ipo_sp500
*
*				Thomas Pellet, Peterson institute for International economics
*
*									  12-06-2017
*
*-------------------------------------------------------------------------------



*-------------------------------------------------------------------------------
*
*					
*									using daily dataset from Stockcharts and Predict It
*
*-------------------------------------------------------------------------------


clear all
*local cmd "E:\Thomas\Trumponomics\Stata\Industry and tax odds"
*cd "`cmd'"

use "dailySP sub index data.dta"

set more off

*cd "`cmd'\interpolate"


* regression of sub indexes on tax probabilities

*choose tax market

local lag = 1
display `lag'



foreach Market of varlist corptaxcut2017 {

	
		foreach t in 7 {
		
		
		local variable "`Market'"
		local persvariable "indivtaxcut2017"
		display `variable'
		*replace with "" when using corptaxcut2017
		local repat "repat"

		*non overlapping change wc for weekly, bwc for bi-weekly, none for 

		*choose growth window
		local window "`t'"
		*choose derivative
		local Dvariable "D`variable'`window'"
		display `Dvariable'
		local dummyvariable "Dcorptaxcut1718`window' corptaxdummy"
		local dummy "bigchangedummy`repat'plus`window' bigchangedummy`repat'minus`window'"
		local onedummy "bigchangedummy`repat'`window'"

		*Pick the control you want one or two:
		local index "1"

		*control for global cycle
		local control "Dlnipo_msci_exus`window'"
		*control for tax hike
		local perscontrol "D`persvariable'`window'"


		*local index "2"
		*local control "Dlnipo_cac40`window' Dlnipo_ftse`window' Dlnipo_nikkei`window'"
		*local lappingcontrol "ipo_cac40`lapping' ipo_ftse`lapping' ipo_nikkei`lapping'"
		local label "all"
		
		*lag selection for NW
	
		if `t' == 1 local lag = 1
		
		if `t' == 7 local lag = 4 
		
		if `t' == 14 local lag = 8
		
		if `t' == 30 local lag = 15
		
		


		*------------------------------------------------------------------------------
		*
		* 			regression of sub indexes CHANGES on tax probabilities differences in logs/logs or log/level
		*
		*-------------------------------------------------------------------------------
		* pick a growth window, 1 = 1 day
		

		*=======================================================================
		*repeat without the 12/20/2017 spike
		reg Dlnipo_sp500`window' `Dvariable' `control' if statadate < td(20dec2017)
		local rsquared = e(r2_a)
		newey Dlnipo_sp500`window' `Dvariable' `control'  if statadate < td(20dec2017), lag(`lag') force 
		outreg2 using Regression/table1.xls, replace ctitle ("") /// 
		label title("Perct. change in ipo_sp500 sub-indexes on `window' days change in `variable' probability with control") addstat(R-squared, `rsquared') ///
		addnote(Newey-West standard error in parentheses `lag' lags, *** p<0.01; ** p<0.05; * p<0.1, 11/09/2017-12/19/2017 ) nonotes


		*october
				
		reg Dlnipo_sp500`window' `Dvariable' `control' if inrange(statadate, td(1oct2017), td(19dec2017))
		local rsquared = e(r2_a)
		newey Dlnipo_sp500`window' `Dvariable' `control' if inrange(statadate, td(1oct2017), td(19dec2017)), lag(`lag') force
		outreg2 using Regression/figure10.xls, replace ctitle ("") /// 
		label title("Perct. change in ipo_sp500 sub-indexes on `window' days change in `variable' probability with control") addstat(R-squared, `rsquared') ///
		addnote(Newey-West standard error in parentheses `lag' lags, *** p<0.01; ** p<0.05; * p<0.1, 10/01/2017-12/19/2017 ) nonotes
				
	
		*=======================================================================
		*repeat from election day to  June
		reg Dlnipo_sp500`window' `Dvariable' `control' if inrange(statadate, td(9nov2016), td(1jun2017))
		local rsquared = e(r2_a)
		newey Dlnipo_sp500`window' `Dvariable' `control'  if inrange(statadate, td(9nov2016), td(1jun2017)), lag(`lag') force 
		outreg2 using Regression/figure11.xls, replace ctitle ("") /// 
		label title("Perct. change in ipo_sp500 sub-indexes on `window' days change in `variable' probability with control") addstat(R-squared, `rsquared') ///
		addnote(Newey-West standard error in parentheses `lag' lags, *** p<0.01; ** p<0.05; * p<0.1, 11/09/2017-06/01/2017 ) nonotes


				*=======================================================================
		*repeat from   June to passage
		reg Dlnipo_sp500`window' `Dvariable' `control' if inrange(statadate, td(1jun2017), td(19dec2017))
		local rsquared = e(r2_a)
		newey Dlnipo_sp500`window' `Dvariable' `control'  if inrange(statadate, td(1jun2017), td(19dec2017)), lag(`lag') force 
		outreg2 using Regression/figure11bis.xls, replace ctitle ("") /// 
		label title("Perct. change in ipo_sp500 sub-indexes on `window' days change in `variable' probability with control") addstat(R-squared, `rsquared') ///
		addnote(Newey-West standard error in parentheses `lag' lags, *** p<0.01; ** p<0.05; * p<0.1, 06/01/2017-12/19/2017 ) nonotes

		*=======================================================================
		*repeat with H2 dummy
		reg Dlnipo_sp500`window' `Dvariable' H2`Dvariable'   `control'  if statadate < td(20dec2017)
		local rsquared = e(r2_a)
		newey Dlnipo_sp500`window' `Dvariable' H2`Dvariable'  `control'  if statadate < td(20dec2017), lag(`lag') force 
		outreg2 using Regression/Table3.xls, replace ctitle ("") /// 
		label title("Perct. change in ipo_sp500 sub-indexes on `window' days change in `variable' probability with control") addstat(R-squared, `rsquared') ///
		addnote(Newey-West standard error in parentheses `lag' lags, *** p<0.01; ** p<0.05; * p<0.1, 06/01/2017-12/19/2017 ) nonotes
		
				*repeat with M dummy for 2017
		reg Dlnipo_sp500`window' `Dvariable'  M11`Dvariable'   `control'  if statadate < td(20dec2017)
		local rsquared = e(r2_a)
		newey Dlnipo_sp500`window' `Dvariable' M11`Dvariable'  `control'  if statadate < td(20dec2017), lag(`lag') force 
		outreg2 using Regression/figure13.xls, replace ctitle ("") /// 
		label title("Perct. change in ipo_sp500 sub-indexes on `window' days change in `variable' probability with control") addstat(R-squared, `rsquared') ///
		addnote(Newey-West standard error in parentheses `lag' lags, *** p<0.01; ** p<0.05; * p<0.1, 06/01/2017-12/19/2017 ) nonotes

				*repeat with Q dummy for 2017
		reg Dlnipo_sp500`window' `Dvariable' Q1`Dvariable' Q2`Dvariable' Q3`Dvariable' Q4`Dvariable' Q1 Q2 Q3 Q4  `control'  if statadate < td(20dec2017)
		local rsquared = e(r2_a)
		newey Dlnipo_sp500`window' `Dvariable' Q1`Dvariable' Q2`Dvariable' Q3`Dvariable' Q4`Dvariable' Q1 Q2 Q3 Q4 `control'  if statadate < td(20dec2017), lag(`lag') force 
		outreg2 using Regression/figure14.xls, replace ctitle ("") /// 
		label title("Perct. change in ipo_sp500 sub-indexes on `window' days change in `variable' probability with control") addstat(R-squared, `rsquared') ///
		addnote(Newey-West standard error in parentheses `lag' lags, *** p<0.01; ** p<0.05; * p<0.1, 06/01/2017-12/19/2017 ) nonotes




		
		*=======================================================================


		foreach var of varlist Dlnipo_materials`window' Dlnipo_energy`window' Dlnipo_financial`window' Dlnipo_industrial`window' Dlnipo_technology`window' Dlnipo_consumerstaples`window' Dlnipo_utilities`window' Dlnipo_healthcare`window' Dlnipo_consumerdiscretionary`window' Dlnipo_realestates`window' Dlnipo_telecommunication`window' {


				*no drop
				
				reg `var' `Dvariable' `control' if statadate < td(20dec2017)
				local rsquared = e(r2_a)
				newey `var' `Dvariable' `control' if statadate < td(20dec2017), lag(`lag') force
				outreg2 using Regression/table1.xls, append ctitle ("") /// 
				label addstat(R-squared, `rsquared') ///
				addnote(Newey-West standard error in parentheses `lag' lags, *** p<0.01; ** p<0.05; * p<0.1, 11/09/2017-12/19/2017 ) nonotes

				*october
				
				reg `var' `Dvariable' `control' if inrange(statadate, td(1oct2017), td(19dec2017))
				local rsquared = e(r2_a)
				newey `var' `Dvariable' `control' if inrange(statadate, td(1oct2017), td(19dec2017)), lag(`lag') force
				outreg2 using Regression/figure10.xls, append ctitle ("") /// 
				label addstat(R-squared, `rsquared') ///
				addnote(Newey-West standard error in parentheses `lag' lags, *** p<0.01; ** p<0.05; * p<0.1, 10/01/2017-12/19/2017 ) nonotes
				
	
				*election day to june
				
				reg `var' `Dvariable' `control' if inrange(statadate, td(9nov2016), td(1jun2017))
				local rsquared = e(r2_a)
				newey `var' `Dvariable' `control'  if inrange(statadate, td(9nov2016), td(1jun2017)), lag(`lag') force
				outreg2 using Regression/figure11.xls, append ctitle ("") /// 
				label addstat(R-squared, `rsquared') ///
				addnote(Newey-West standard error in parentheses `lag' lags, *** p<0.01; ** p<0.05; * p<0.1, 11/09/2017-06/01/2017 ) nonotes
				
	
				*June to passage
				
				reg `var' `Dvariable' `control' if inrange(statadate, td(1jun2017), td(19dec2017))
				local rsquared = e(r2_a)
				newey `var' `Dvariable' `control'  if inrange(statadate, td(1jun2017), td(19dec2017)), lag(`lag') force
				outreg2 using Regression/figure11bis.xls, append ctitle ("") /// 
				label addstat(R-squared, `rsquared') ///
				addnote(Newey-West standard error in parentheses `lag' lags, *** p<0.01; ** p<0.05; * p<0.1, 06/01/2017-12/19/2017 ) nonotes
				
				*repeat with H2 dummy
				reg `var' `Dvariable' H2`Dvariable' `control'  if statadate < td(20dec2017)
				local rsquared = e(r2_a)
				newey `var' `Dvariable' H2`Dvariable' `control'   if statadate < td(20dec2017), lag(`lag') force 
				outreg2 using Regression/Table3.xls, append ctitle ("") /// 
				label addstat(R-squared, `rsquared') ///
				addnote(Newey-West standard error in parentheses `lag' lags, *** p<0.01; ** p<0.05; * p<0.1, 06/01/2017-12/19/2017 ) nonotes


				*repeat with H2 dummy
				reg `var' `Dvariable' M11`Dvariable'  `control' if statadate < td(20dec2017)
				local rsquared = e(r2_a)
				newey `var' `Dvariable' M11`Dvariable'  `control'  if statadate < td(20dec2017), lag(`lag') force 
				outreg2 using Regression/figure13.xls, append ctitle ("") /// 
				label addstat(R-squared, `rsquared') ///
				addnote(Newey-West standard error in parentheses `lag' lags, *** p<0.01; ** p<0.05; * p<0.1, 06/01/2017-12/19/2017 ) nonotes


								*repeat with H2 dummy
				reg `var' `Dvariable' Q1`Dvariable' Q2`Dvariable' Q3`Dvariable' Q4`Dvariable' Q1 Q2 Q3 Q4 `control' if statadate < td(20dec2017)
				local rsquared = e(r2_a)
				newey `var' `Dvariable' Q1`Dvariable' Q2`Dvariable' Q3`Dvariable' Q4`Dvariable' Q1 Q2 Q3 Q4 `control'  if statadate < td(20dec2017), lag(`lag') force 
				outreg2 using Regression/figure14.xls, append ctitle ("") /// 
				label addstat(R-squared, `rsquared') ///
				addnote(Newey-West standard error in parentheses `lag' lags, *** p<0.01; ** p<0.05; * p<0.1, 06/01/2017-12/19/2017 ) nonotes

				
		}
	}
	
}


